/*
 * Decompiled with CFR 0.152.
 */
package panther.util.resource;

import panther.util.resource.Resource;
import panther.util.resource.ResourceReleasedException;
import panther.util.resource.ResourceRevokedException;
import panther.util.resource.ResourceThing;
import panther.util.resource.ResourceTimedOutException;

public abstract class ResourceComponent
extends ResourceThing {
    protected ResourceThing parent;
    protected Object rawResourceComponent;
    protected String description;

    public ResourceComponent(ResourceThing resourceThing, Object object) {
        this.parent = resourceThing;
        resourceThing.addComponent(this);
        this.rawResourceComponent = object;
        String string = null;
        try {
            string = object.toString();
        }
        catch (Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                throw (ThreadDeath)throwable;
            }
            string = object.getClass().getName();
        }
        this.description = resourceThing.toString() + " ==> ResourceComponent #" + this.number + " on " + string;
    }

    protected abstract void closeRawResource();

    public abstract boolean needsToBeCleared();

    public Resource getTopResource() {
        return this.parent == null ? null : this.parent.getTopResource();
    }

    public boolean isActive() {
        return this.parent != null && this.parent.isActive();
    }

    public boolean released() {
        return this.parent != null && this.parent.released();
    }

    public boolean timedOut() {
        return this.parent != null && this.parent.timedOut();
    }

    Object getRawResourceComponent() {
        return this.rawResourceComponent;
    }

    public String toString() {
        return this.description;
    }

    void clear() {
        this.clear(false);
    }

    public void clear(boolean bl) {
        super.clear();
        if (this.needsToBeCleared() && !bl) {
            this.getResourceLog().log(2, "Clearing " + this);
        }
        this.closeRawResource();
        this.rawResourceComponent = null;
        this.parent = null;
        this.description = this.description + " (cleared)";
    }

    protected void checkActive() {
        if (!this.isActive()) {
            if (this.timedOut()) {
                throw new ResourceTimedOutException("Attempt to access a timed out resource component: " + this);
            }
            if (this.released()) {
                throw new ResourceReleasedException("Attempt to access a released resource component: " + this);
            }
            throw new ResourceRevokedException("Attempt to access a revoked resource component: " + this);
        }
    }
}

